from fastapi import FastAPI, UploadFile, File, Form, HTTPException
from fastapi.responses import JSONResponse
import aiofiles, os, uuid, json
from pathlib import Path
from ..tools.feature_flags import load_flags

app = FastAPI(title='Luna L1-D21 API - Dev')

DATA_DIR = Path(__file__).resolve().parents[1] / 'data'
os.makedirs(DATA_DIR, exist_ok=True)

@app.get('/health')
async def health():
    return {'status':'ok','release': load_flags().get('meta',{}).get('release')}

@app.post('/ingest')
async def ingest(file: UploadFile = File(...), station_id: str = Form('unknown')):
    # simple ingestion endpoint - saves uploaded file to data/ and returns meta
    try:
        raw_id = str(uuid.uuid4())
        outpath = DATA_DIR / f"{station_id}_{raw_id}_{file.filename}"
        async with aiofiles.open(outpath, 'wb') as out_file:
            content = await file.read()
            await out_file.write(content)
        meta = {'station_id': station_id, 'filename': file.filename, 'saved_as': str(outpath)}
        return JSONResponse(content=meta)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

@app.get('/features')
async def features():
    flags = load_flags()
    return JSONResponse(content=flags)
