import matplotlib.pyplot as plt
import numpy as np

def compost_equation_visual(seed=1, outpath=None):
    # Simple symbolic visual: concentric rings where radii are derived from 'compost' factors
    np.random.seed(seed)
    layers = 5
    radii = np.linspace(0.2, 1.0, layers)
    colors = plt.cm.viridis(np.linspace(0,1,layers))
    fig, ax = plt.subplots(figsize=(6,6))
    for r,c in zip(radii, colors):
        circle = plt.Circle((0,0), r, color=c, alpha=0.6)
        ax.add_artist(circle)
    ax.set_xlim(-1.1,1.1)
    ax.set_ylim(-1.1,1.1)
    ax.set_aspect('equal')
    ax.axis('off')
    ax.set_title('Compost Equation Visual (symbolic)')
    if outpath:
        fig.savefig(outpath, bbox_inches='tight')
        plt.close(fig)
    else:
        plt.show()

if __name__ == '__main__':
    compost_equation_visual(outpath='compost_visual.png')
